function [left_t_bound,left_I_bound,right_t_bound,right_I_bound,Final_dt_array]=FWHM_Linear_Light(event_data,Final_level_pts,BSL,BSR,Final_mean_I_array,Final_dt_array)

first_level_start=Final_level_pts(1);
first_level_end=Final_level_pts(2);

%left bound
    first_level_data=event_data(first_level_start:first_level_end);
    [~,min_index]=min(first_level_data);
    true_min_index=first_level_start+min_index;

    base_L_threshold=BSL*0.999;
    if isempty(base_L_threshold)==0 && isempty(true_min_index)==0
        
        while event_data(true_min_index)<=base_L_threshold && true_min_index>1
            true_min_index=true_min_index-1;
        end

        level_delta_I=BSL-Final_mean_I_array(1);
        ten_percent_I=BSL-(0.1*level_delta_I);
        fifty_percent_I=BSL-(0.5*level_delta_I);
        ninety_percent_I=BSL-(0.9*level_delta_I);

        while event_data(true_min_index)>=ten_percent_I && true_min_index<first_level_end
            true_min_index=true_min_index+1;
        end
        ten_percent_bound=true_min_index;

        while event_data(true_min_index)>=ninety_percent_I && true_min_index<first_level_end
        true_min_index=true_min_index+1;
        end
        ninety_percent_bound=true_min_index;

        I_ten_ninety_I=event_data(ten_percent_bound-1:ninety_percent_bound);%we go one over to be in the baseline
        I_ten_ninety_t=(ten_percent_bound-1:ninety_percent_bound)';%we go one over to be in the baseline

        X=[ones(length(I_ten_ninety_t),1) I_ten_ninety_t];
        coeffs=X\I_ten_ninety_I;%y=c+mx
        slope_cal=coeffs(2);
        intercept_cal=coeffs(1);

        left_t_bound=(fifty_percent_I-intercept_cal)/slope_cal;
        left_I_bound=fifty_percent_I;
    else
        left_t_bound=first_level_start;
        left_I_bound=BSL;
    end
%Right Bound

last_level_start=Final_level_pts(end-1);
last_level_end=Final_level_pts(end);
    
    last_level_data=event_data(last_level_start:last_level_end);
    [~,min_index]=min(last_level_data);
    true_min_index=last_level_start+min_index;

    base_R_threshold=BSR*0.999;
    if isempty(base_R_threshold)==0 && isempty(true_min_index)==0
        
        while event_data(true_min_index)<base_R_threshold && true_min_index>1
            true_min_index=true_min_index+1;
        end

        level_delta_I=BSR-Final_mean_I_array(end);
        ten_percent_I=BSR-(0.1*level_delta_I);
        fifty_percent_I=BSR-(0.5*level_delta_I);
        ninety_percent_I=BSR-(0.9*level_delta_I);

        while event_data(true_min_index)>=ten_percent_I && true_min_index>last_level_start
            true_min_index=true_min_index-1;
        end
        ten_percent_bound=true_min_index;

        while event_data(true_min_index)>=ninety_percent_I && true_min_index>last_level_start
        true_min_index=true_min_index-1;
        end
        ninety_percent_bound=true_min_index;

        I_ten_ninety_I=event_data(ninety_percent_bound:ten_percent_bound+1);%we go one over to be in the baseline
        I_ten_ninety_t=(ninety_percent_bound:ten_percent_bound+1)';%we go one over to be in the baseline

        X=[ones(length(I_ten_ninety_t),1) I_ten_ninety_t];
        coeffs=X\I_ten_ninety_I;%y=c+mx
        slope_cal=coeffs(2);
        intercept_cal=coeffs(1);

        right_t_bound_prel=(fifty_percent_I-intercept_cal)/slope_cal;
        if right_t_bound_prel>(last_level_start+last_level_end)/2
            right_t_bound=right_t_bound_prel;
            right_I_bound=fifty_percent_I;
        else
            right_t_bound=last_level_end;
            right_I_bound=BSR;
        end
        
    else
        right_t_bound=last_level_end;
        right_I_bound=BSR;
    end
    %dt adjustment
        if length(Final_dt_array)>1
            Final_dt_array(end)=right_t_bound-last_level_start;
            Final_dt_array(1)=first_level_end-left_t_bound;
        elseif length(Final_dt_array)==1
            Final_dt_array(1)=right_t_bound-left_t_bound;
        end
end